﻿using System;
using System.Net;

namespace iXTankenAndroid
{
    public abstract class ViewModelBase
    {

        public void Initialize()
        {
        }

        protected T GetService<T>() where T : class 
        { 
            if (typeof(T) == typeof(INavigationService)) 
            { 
                return new iXTankenNavigationService() as T; 
            } 
            else if (typeof(T) == typeof(ITankvorgangModelService)) 
            { 
                return new InMemoryTankVorgangModelService() as T; 
            } 
            return null; 
        }
    }
}
